% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9.mdph.R
\name{MoE,mdph-method}
\alias{MoE,mdph-method}
\title{MoE method for mdph Class}
\usage{
\S4method{MoE}{mdph}(
  x,
  formula,
  y,
  data,
  alpha_vecs = NULL,
  weight = numeric(0),
  stepsEM = 1000,
  every = 10,
  rand_init = TRUE,
  maxWts = 1000
)
}
\arguments{
\item{x}{An object of class \linkS4class{mdph}.}

\item{formula}{A regression formula.}

\item{y}{A matrix of observations.}

\item{data}{A data frame of covariates.}

\item{alpha_vecs}{Matrix of initial probabilities.}

\item{weight}{Vector of weights.}

\item{stepsEM}{Number of EM steps to be performed.}

\item{every}{Number of iterations between likelihood display updates.}

\item{rand_init}{Random initiation in the R-step.}

\item{maxWts}{Maximal number of weights in the nnet function.}
}
\value{
An object of class \linkS4class{sph}.
}
\description{
MoE method for mdph Class
}
\examples{
x <- mdph(structure = c("general", "general"))
n <- 100
responses <- cbind(rpois(n, 3) + 1, rbinom(n, 5, 0.5))
covariates <- data.frame(age = sample(18:65, n, replace = TRUE) / 100, income = runif(n, 0, 0.99))
f <- responses ~ age + income
MoE(x = x, formula = f, y = responses, data = covariates, stepsEM = 20)
}
