% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log2.R
\name{log2}
\alias{log2}
\title{Base 2 logarithm}
\usage{
log2(X, dissect = TRUE)
}
\arguments{
\item{X}{a scalar or vector of numbers}

\item{dissect}{if \code{TRUE}, returns the mantissa and exponent.}
}
\value{
either a vector or a list of mantissas and exponents such that
mantissa * 2 ^ exponent equals X
}
\description{
Base 2 logarithm and floating-point number dissection
}
\examples{
log2(10, dissect = FALSE)
log2(10)
.625 * 2 ^ 4 == 10  # proof
}
