% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markdownInput.R
\name{markdownInput}
\alias{markdownInput}
\title{Create a markdown input control with a result preview}
\usage{
markdownInput(
  inputId,
  label,
  value = "Some **markdown** _text_",
  theme = "github",
  height = "400px",
  class = ""
)
}
\arguments{
\item{inputId}{The code{input} slot that will be used to access the value.}

\item{label}{Label of the input.}

\item{value}{The initial text to be contained in the editor.}

\item{theme}{The Ace theme to be used by the editor. The theme in Ace
determines the styling and coloring of the editor.
Use \code{\link[shinyAce]{getAceModes}} to enumerate all the themes
available.}

\item{height}{A number (which will be interpreted as a number of pixels) or
any valid CSS dimension (such as "50\%", "200px", or "auto").}

\item{class}{The CSS class name of the input. (optional)}
}
\value{
A tabset containing two tabs: \enumerate{ \item{"Write" tab:
  }{Containing a code editor (\code{\link[shinyAce]{aceEditor}}).}
  \item{"Preview" tab: }{Containing the preview of the markdown render.} }
}
\description{
Create a markdown input control with a result preview
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
 library(shiny)
 library(markdownInput)
 ui <- fluidPage(titlePanel("Markdown input"),
                 sidebarLayout(
                   # inputs:
                   sidebarPanel(
                     markdownInput(
                       "mdInputID",
                       label = "Write your text",
                       value = "Write some _markdown_ **here:**"
                       )
                   ),

                   # outputs:
                   mainPanel(
                   h3("Raw value of the input:"),
                   verbatimTextOutput("rawResult"))
                 ))

 server <- function(input, output, session) {
   # myText is a reactive variable containing the raw markdown text
   myText <- callModule(moduleMarkdownInput, "mdInputID")

   # show "myText"
   output$rawResult <- renderPrint({
     print(myText())
   })

 }

 shinyApp(ui, server)

}
}
\references{
\enumerate{
 \item{\href{https://CRAN.R-project.org/package=shinyAce}{shinyAce} package:
}{Vincent Nijs, Forest Fang, Trestle Technology, LLC and Jeff Allen (2019).
shinyAce: Ace Editor Bindings for Shiny.}

\item{\href{https://CRAN.R-project.org/package=shiny}{shiny} package: }{
Winston Chang, Joe Cheng, JJ Allaire, Yihui Xie and Jonathan McPherson
(2018). shiny: Web Application Framework for R.}

\item{\href{https://CRAN.R-project.org/package=markdown}{markdown} package:
}{ JJ Allaire, Jeffrey Horner, Yihui Xie, Vicent Marti and Natacha Porte
(2018). markdown: 'Markdown' Rendering for R.} }
}
\author{
Julien Diot \email{juliendiot42@gmail.com}
}
