% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_using_data.R
\name{map_using_data}
\alias{map_using_data}
\title{Join district or state level data to India mapping data}
\usage{
map_using_data(data, values = "values", include = c(), exclude = c(), na = NA)
}
\arguments{
\item{data}{The data that should be joined to a India map. This
parameter should be a data frame consisting of two columns,
a code (2 characters for state, 5 characters for district where first 2
characters correspond to the respective state) and the value that should
be associated with that region. The columns of \code{data} \emph{must} be
\code{code} or \code{state} and the value of the `values` parameter. If
both \code{code} and \code{state} are provided, this function uses the
\code{code}.}

\item{values}{The name of the column that contains the values to be associated
with a given region. The default is \code{"values"}.}

\item{include}{The regions to include in the resulting map. If \code{regions} is
\code{"states"}/\code{"state"}, the value can be either a state name, abbreviation or code.
For districts, the district codes must be provided as there can be multiple districts with the
same name. If states are provided in the districts map, only districts in the included states
will be returned.}

\item{exclude}{The regions to exclude in the resulting map. If \code{regions} is
\code{"states"}/\code{"state"}, the value can be either a state name, abbreviation or code.
For districts, the district codes must be provided as there can be multiple districts with the
same name. The regions listed in the \code{include} parameter are applied first and the
\code{exclude} regions are then removed from the resulting map. Any excluded regions
not present in the included regions will be ignored.}

\item{na}{The value to be inserted for states or districts that don't have
a value in \code{data}. This value must be of the same type as the \code{value}
column of \code{data}.}
}
\value{
A data frame composed of the map data frame (from [map_india()]) except
  an extra column containing the values in \code{data} is included.

  The result can be plotted using [ggplot2::ggplot()] or [plot_india()].
}
\description{
Join district or state level data to India mapping data
}
\examples{
data_01 <- data.frame(code = c("01", "02", "04"), values = c(1, 5, 8))
df <- map_using_data(data_01, na = 0)

data_02 <- data.frame(state = c("AP", "WB", "Tamil Nadu"), values = c(6, 9, 3))
df <- map_using_data(data_02, na = 0)

}
\seealso{
[plot_india()]
}
