% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_lm_list.R
\name{summary.lm_list}
\alias{summary.lm_list}
\alias{print.summary_lm_list}
\title{Summary of an \code{lm_list}-Class
Object}
\usage{
\method{summary}{lm_list}(object, betaselect = FALSE, ci = FALSE, level = 0.95, ...)

\method{print}{summary_lm_list}(x, digits = 3, digits_decimal = NULL, ...)
}
\arguments{
\item{object}{The output of
\code{\link[=lm2list]{lm2list()}}.}

\item{betaselect}{If \code{TRUE},
standardized coefficients are
computed and included in the
printout. Only numeric variables will
be computed, and any derived terms,
such as product terms, will be formed
\emph{after} standardization. Default
is \code{FALSE}.}

\item{ci}{If \code{TRUE}, confidence
interval based on \emph{t} statistic
and standard error will be computed
and added to the output. Default is
\code{FALSE}.}

\item{level}{The level of confidence
of the confidence interval. Ignored
if \code{ci} is not \code{TRUE}.}

\item{...}{Other arguments. Not
used.}

\item{x}{An object of class
\code{summary_lm_list}.}

\item{digits}{The number of
significant digits in printing
numerical results.}

\item{digits_decimal}{The number of
digits after the decimal in printing
numerical results. Default is \code{NULL}.
If set to an integer, numerical
results in the coefficient table
will be printed according this setting,
and \code{digits} will be ignored.}
}
\value{
\code{\link[=summary.lm_list]{summary.lm_list()}} returns a
\code{summary_lm_list}-class object, which
is a list of the \code{\link[=summary]{summary()}} outputs
of the \code{\link[=lm]{lm()}} outputs stored.

\code{\link[=print.summary_lm_list]{print.summary_lm_list()}} returns \code{x}
invisibly. Called for its side
effect.
}
\description{
The summary of content
of the output of \code{\link[=lm2list]{lm2list()}}.
}
\section{Functions}{
\itemize{
\item \code{print(summary_lm_list)}: Print
method for output of summary for
lm_list.

}}
\examples{

data(data_serial_parallel)
lm_m11 <- lm(m11 ~ x + c1 + c2, data_serial_parallel)
lm_m12 <- lm(m12 ~ m11 + x + c1 + c2, data_serial_parallel)
lm_m2 <- lm(m2 ~ x + c1 + c2, data_serial_parallel)
lm_y <- lm(y ~ m11 + m12 + m2 + x + c1 + c2, data_serial_parallel)
# Join them to form a lm_list-class object
lm_serial_parallel <- lm2list(lm_m11, lm_m12, lm_m2, lm_y)
lm_serial_parallel
summary(lm_serial_parallel)

}
