% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parties.R
\name{mp_parties}
\alias{mp_parties}
\title{Access to the Parties Lists for the Manifesto Project Data}
\usage{
mp_parties(
  version = "current",
  apikey = NULL,
  cache = TRUE,
  list_form = "short"
)
}
\arguments{
\item{version}{version of the Manifesto Project Main Dataset for which the
list of parties is requested. Note: the list of parties is not available for all of the past datasets. 
Defaults to "current", which fetches the most recent version. Must be formatted as e.g. "MPDS2023a".}

\item{apikey}{API key to use. Defaults to \code{NULL}, resulting in using
the API key set via \code{\link{mp_setapikey}}.}

\item{cache}{Whether result of API call should be cached locally (defaults to TRUE)}

\item{list_form}{Whether the result should be the short or the long version (defaults to "short")}
}
\description{
These functions provide access to machine-readable versions
of the List of Parties of the Manifesto Project Data as can be found in CSV form 
under https://manifesto-project.wzb.eu/datasets .
Note: the list of parties is not available for all of the past datasets. You can check the 
availability by going to the datasets page and check for specific datasets whether they have 
party lists in the following formats "List – Short (CSV)" or "List – Long (CSV)" available. 
There you can also find the codebooks with details for these list of parties.
}
\details{
\code{mp_parties} returns the list of parties as a \code{tibble}, ideal for further automatic processing.
}
