% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state.R
\name{wemo_STATE}
\alias{wemo_STATE}
\title{Check WeMo Switch State}
\usage{
wemo_STATE(ip)
}
\arguments{
\item{ip}{A characted string or vector of character strings representing the
IP address(es) of WeMo Switch smart plug(s).}
}
\value{
A \code{\link[tibble]{tibble}} with two columns:
  \describe{
    \item{ip}{The IP address of the WeMo Switch smart plug}
    \item{state}{'ON' if the WeMo Switch is turned on, 'OFF' if it is turned
                 off. NA will be returned is no WeMo Switch is detected at
                 this IP.}
  }
}
\description{
Check the ON/OFF state of WeMo Switch smart plugs.
}
\examples{
\dontrun{
wemo_STATE("192.0.1.1")
}

}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
