% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_orthologs.R
\name{load_orthologs}
\alias{load_orthologs}
\title{load orthologs with their genomic coordinates.}
\usage{
load_orthologs(
  orthologs_table,
  sp1_bed = NULL,
  sp2_bed = NULL,
  bedfiles = NULL
)
}
\arguments{
\item{orthologs_table}{character. Full path to the orthologs table (format : geneID_on_species1   geneID_on_species2   geneID_on_speciesN)}

\item{sp1_bed}{(deprecated) character. Full path to the genomic coordinates of the genes on species1}

\item{sp2_bed}{(deprecated) character. Full path to the genomic coordinates of the genes on species2}

\item{bedfiles}{array. List of full paths to the genomic coordinates ordered as in the appearing order of the orthologs_table (BED format)}
}
\value{
dataframe composed of genomic coordinates and relative index of orthologs on both species
}
\description{
Puts together the table of orthologous genes with their genomic coordinates
in the two or more species. It outputs a data.frame shaped as following :
sp1.ID,sp1.Chr,sp1.Start,sp1.End,sp1.Index,sp2.ID,sp2.Chr,sp2.Start,sp2.End,sp2.Index,...
}
\examples{
# basic usage of load_orthologs for two species :

orthologs_file <- system.file("extdata","Bflo_vs_Pyes.tab",package="macrosyntR")
bedfile_sp1 <- system.file("extdata","Bflo.bed",package="macrosyntR")
bedfile_sp2 <- system.file("extdata","Pyes.bed",package="macrosyntR")


my_orthologs <- load_orthologs(orthologs_table = orthologs_file,
                               bedfiles = c(bedfile_sp1,bedfile_sp2))
# example with 3 species :
orthologs_file <- system.file("extdata","Single_copy_orthologs.tsv",package="macrosyntR")
bedfile_sp3 <- system.file("extdata","Pech.bed",package="macrosyntR")

my_orthologs <- load_orthologs(orthologs_table = orthologs_file,
                               bedfiles = c(bedfile_sp1,bedfile_sp2,bedfile_sp3))


}
