% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_syntenic_genes.R
\name{get_syntenic_genes}
\alias{get_syntenic_genes}
\title{get the syntenic genes as a table}
\usage{
get_syntenic_genes(orthologs_df)
}
\arguments{
\item{orthologs_df}{dataframe. orthologs with genomic coordinates loaded by load_orthologs()}
}
\value{
dataframe composed of details for each detected syntenic block of genes. It contains the following columns : sp1.Chr, sp1.Start, sp1.End, sp2.Chr, sp2.Start, sp2.End, size, sp1.IDs, sp2.IDs
}
\description{
This is a function to extract all the syntenic genes from an orthologs_df. It requires as input an orthologs_df loaded by load_orthologs().
}
\examples{
# basic usage of get_syntenic_genes :

orthologs_table <- system.file("extdata","my_orthologs.tab",package="macrosyntR")

my_orthologs <- read.table(orthologs_table,header=TRUE)
                               
my_syntenic_block_of_genes <- get_syntenic_genes(my_orthologs)

}
\seealso{
\code{\link[=load_orthologs]{load_orthologs()}}
}
