% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symtable.R
\name{print.symtable}
\alias{print.symtable}
\title{Print the Macro Symbol Table}
\usage{
\method{print}{symtable}(x, ..., verbose = FALSE)
}
\arguments{
\item{x}{The format catalog to print.}

\item{...}{Any follow-on parameters.}

\item{verbose}{Whether or not to print the format catalog in verbose style.
By default, the parameter is FALSE, meaning to print in tabular style.}
}
\value{
The object, invisibly.
}
\description{
A class-specific instance of the \code{print} function for
a macro symbol table and function list.
Use \code{verbose = TRUE} to print the catalog as a list.
}
\examples{
library(macro)

# Get path to demo macro program
src <- system.file("extdata/Demo4.R", package = "macro")

# Execute source code
msource(src, echo = FALSE)

# Examine symbol table
res <- symtable()

# View results
print(res)
# # Macro Symbol Table: 3 macro variables
#   Name Value
# 1   &x     1
# 2   &y     2
# 3   &z 1 + 2
# # Macro Function List: 1 macro functions
#   Name Parameter Default
# 1 test        vl  Hello!

# View results structure
print(res, verbose = TRUE)
# $variables
# $variables$`&x`
# [1] "1"
#
# $variables$`&y`
# [1] "2"
#
# $variables$`&z`
# [1] "1 + 2"
#
#
# $functions
# $functions$test
# $functions$test$parameters
# $functions$test$parameters$vl
# [1] "Hello!"
#
#
# $functions$test$code
# [1] "print(\"&vl\")"
# attr(,"start")
# [1] 8
# attr(,"end")
# [1] 8

}
\seealso{
\code{\link[=msource]{msource()}}

Other symtable: 
\code{\link{symclear}()},
\code{\link{symget}()},
\code{\link{symput}()},
\code{\link{symtable}()}
}
\concept{fcat}
\concept{symtable}
