% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliHoldridge.R
\name{cliHoldridgeGrid}
\alias{cliHoldridgeGrid}
\title{Vegetation Classifier Using the HLZ System}
\usage{
cliHoldridgeGrid(rs.temp, rs.prec, verbose = FALSE, filename = "", ...)
}
\arguments{
\item{rs.temp}{multi-layer Raster*/SpatRaster object with one-year time series of monthly mean air temperature
(in °C)}

\item{rs.prec}{multi-layer Raster*/SpatRaster object with one-year time series of monthly precipitation sum
(in mm)}

\item{verbose}{'logical' scalar that indicates whether or not values of the bioclimatic indices used should be
added to the output.}

\item{filename}{output filename}

\item{...}{additional arguments passed on to \code{\link[terra]{writeRaster}}}
}
\value{
Depending on the setting, a SpatRaster object with one or more layers where the numeric integers encoding
    the HLZ type are stored at the last layer, while the additional layers contain the values of bioclimatic
    indices used. The meaning of integers is given in the data frame \code{\link[macroBiome]{vegClsNumCodes}}. If
    \code{verbose = FALSE}, the return object is a single-layer SpatRaster obejct with numeric integers encoding
    the HLZ type.
}
\description{
Calculates the values of bioclimatic indices used in the Holdridge life zone (HLZ) system
    (Holdridge 1947, 1967), and designates the HLZ type using these values, for a given region, by using the
    monthly time series of temperature and precipitation.
}
\details{
See \code{\link[macroBiome]{cliHoldridgePoints}}.
}
\note{
The objects \code{'rs.temp'} and \code{'rs.prec'} must be 12-layer Raster*/SpatRaster objects. These
    Raster*/SpatRaster objects must have the same bounding box, projection, and resolution.
}
\examples{
# Loading mandatory data for the Example 'Climate Normal Grid'
data(inp_exClnrGrid)

# Designate the HLZ types (using the related bioclimatic indices)
# for Csongrad-Csanad County (for the normal period 1981-2010)
with(inp_exClnrGrid, {
rs.HLZ <- cliHoldridgeGrid(temp, prec, verbose = TRUE)
rs.HLZ
})

}
\references{
\cite{Holdridge LR (1947) Determination of World Plant Formations From Simple Climatic Data. Science
    105(2727):367–368. \doi{10.1126/science.105.2727.367}}

\cite{Holdridge LR (1967) Life zone ecology. Tropical Science Center, San Jose, Costa Rica}
}
