% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrc_boot_CI.R
\name{closedCI}
\alias{closedCI}
\title{Multi-visit closed population mark-recapture estimates}
\usage{
closedCI(
  marked,
  caught,
  recaptured,
  newmarks = NULL,
  alpha = 0.05,
  ndraws = 1e+05
)
}
\arguments{
\item{marked}{number of animals marked on first visit (M2)}

\item{caught}{vector of catch on subsequent visits (nk)}

\item{recaptured}{vector of recaptures on subsequent visits (mk)}

\item{newmarks}{vector of newly marked animals on subsequent visits (default: nk-mk)}

\item{alpha}{type I error rate for confidence intervals (default: 0.05)}

\item{ndraws}{number of bootstrap draws (default: 10,000)}
}
\value{
Matrix containing population size estimates with confidence intervals for each method
}
\description{
Calculate adjusted Schnabel and Schumacher-Eschmeyer estimates with confidence intervals.
}
\details{
Bias adjusted estimators are based on Dettloff (2023).
Bootstrap confidence intervals are computed using a beta-binomial distribution with n = nk, alpha = mk, beta = nk-mk.
}
\examples{
M2 = 2
n = c(232, 524, 152, 98, 353)
m = c(0, 5, 8, 6, 13)
set.seed(123)
closedCI(M2, n, m, ndraws = 1000)
}
\references{
Dettloff, K. (2023). Assessment of bias and precision among simple closed population mark-recapture estimators.
Fisheries Research 265, 106756. doi: <https://doi.org/10.1016/j.fishres.2023.106756>
}
