% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lucas.r
\name{Upload_to_db}
\alias{Upload_to_db}
\title{Update csv to database}
\usage{
Upload_to_db(data_dir, con)
}
\arguments{
\item{data_dir}{Character. Folder where you saved all the micro data downloaded from EUROSTAT}

\item{con}{PosGresSQLConnection Object.}
}
\value{
Boolean. True if the update to the DB worked FALSE otherwise
}
\description{
Upload to the DB all the 2009-2018 lucas csv downloaded from : \url{https://ec.europa.eu/eurostat/web/lucas/data/primary-data} there should be:
EU_2012_20200213.CSV
EU_2018_20200213.CSV
OutScope_2015_20200225.CSV
EU_2009_20200213.CSV
EU_2015_20200225.CSV
For 2006 it first combines them into one dataset for the entire year comprising of:
BE_2006_0.xls
CZ_2006_0.xls
DE_2006_0.xls
ES_2006_0.xls
FR_2006_0.xls
HU_2006_0.xls
IT_2006_0.xls
LU_2006_0.xls
NL_2006_0.xls
PL_2006_0.xls
SK_2006_0.xls
}
\examples{
\dontrun{
Upload_to_db('/data/LUCAS_harmo/data/input', con)}
}
\seealso{
To create the conection please see
lucas]{Connect_to_db}

To assert that you have the files \link[lucas]{Assert_files}
}
