% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsprobust.plot.R
\name{lsprobust.plot}
\alias{lsprobust.plot}
\title{Graphic Presentation of Results for \pkg{lspartition} Package}
\usage{
lsprobust.plot(..., alpha = NULL, type = NULL, CS = "ci",
  CStype = NULL, title = "", xlabel = "", ylabel = "", lty = NULL,
  lwd = NULL, lcol = NULL, pty = NULL, pwd = NULL, pcol = NULL,
  CSshade = NULL, CScol = NULL, legendTitle = NULL,
  legendGroups = NULL)
}
\arguments{
\item{...}{Objects returned by \code{\link{lsprobust}}.}

\item{alpha}{Numeric scalar between 0 and 1, the significance level for plotting
confidence regions. If more than one is provided, they will be applied
to data series accordingly.}

\item{type}{String, one of \code{"line"} (default), \code{"points"}, \code{"binscatter"},
\code{"none"} or \code{"both"}, how the point estimates are plotted. If more
than one is provided, they will be applied to data series accordingly.}

\item{CS}{String, type of confidence sets. Options are \code{"ci"} for pointwise confidence
intervals, \code{"cb"} for uniform confidence bands, and \code{"all"} for both.}

\item{CStype}{String, one of \code{"region"} (shaded region, default), \code{"line"}
(dashed lines), \code{"ebar"} (error bars), \code{"all"} (all of the previous)
or \code{"none"} (no confidence region), how the confidence region should
be plotted. If more than one is provided, they will be applied to data series accordingly.
If \code{CS = "all"}, pointwise confidence intervals are forced to be represented by error bars,
and uniform bands are represented by both lines and regions.}

\item{title}{String, title of the plot.}

\item{xlabel}{Strings, labels for x-axis.}

\item{ylabel}{Strings, labels for y-axis.}

\item{lty}{Line type for point estimates, only effective if \code{type} is \code{"line"} or
\code{"both"}. \code{1} for solid line, \code{2} for dashed line, \code{3}
for dotted line. For other options, see the instructions for \code{\link[ggplot2]{ggplot2}}
or \code{\link{par}}. If more than one is provided, they will be applied to data
series accordingly.}

\item{lwd}{Line width for point estimates, only effective if \code{type} is \code{"line"}
or \code{"both"}. Should be strictly positive. For other options, see the
instructions for \code{\link[ggplot2]{ggplot2}} or \code{\link{par}}. If more than one
is provided, they will be applied to data series accordingly.}

\item{lcol}{Line color for point estimates, only effective if \code{type} is \code{"line"} or
\code{"both"}. \code{1} for black, \code{2} for red, \code{3} for green,
\code{4} for blue. For other options, see the instructions for \code{\link[ggplot2]{ggplot2}}
or \code{\link{par}}. If more than one is provided, they will be applied to
data series accordingly.}

\item{pty}{Scatter plot type for point estimates, only effective if \code{type} is
\code{"points"} or \code{"both"}. For options, see the instructions for
\code{\link[ggplot2]{ggplot2}} or \code{\link{par}}. If more than one is provided,
they will be applied to data series accordingly.}

\item{pwd}{Scatter plot size for point estimates, only effective if \code{type} is
\code{"points"} or \code{"both"}. Should be strictly positive. If more than
one is provided, they will be applied to data series accordingly.}

\item{pcol}{Scatter plot color for point estimates, only effective if \code{type} is
\code{"points"} or \code{"both"}. \code{1} for black, \code{2} for red,
\code{3} for green, \code{4} for blue. For other options, see the instructions
for \code{\link[ggplot2]{ggplot2}} or \code{\link{par}}. If more than one is provided,
they will be applied to data series accordingly.}

\item{CSshade}{Numeric, opaqueness of the confidence region, should be between 0
(transparent) and 1. Default is 0.2. If more than one is provided,
they will be applied to data series accordingly.}

\item{CScol}{Color for confidence region. \code{1} for black, \code{2} for red, \code{3}
for green, \code{4} for blue. For other options, see the instructions for
\code{\link[ggplot2]{ggplot2}} or \code{\link{par}}. If more than one is provided,
they will be applied to data series accordingly.}

\item{legendTitle}{String, title of legend.}

\item{legendGroups}{String vector, group names used in legend.}
}
\value{
A standard \code{\link[ggplot2]{ggplot2}} object is returned, hence can be used for further
       customization.
}
\description{
\code{lsprobust.plot} plots estimated regression functions and confidence regions using the \pkg{lspartition} package.
            See \href{https://sites.google.com/site/nppackages/lspartition/Cattaneo-Farrell_2013_JoE.pdf?attredirects=0}{Cattaneo and Farrell (2013)} and \href{https://arxiv.org/abs/1804.04916}{Cattaneo, Farrell and Feng (2020a)} for complete details.

            Companion command: \code{\link{lsprobust}} for partitioning-based least squares regression
            estimation and inference; \code{\link{lsprobust.plot}} for plotting results; \code{\link{lsplincom}} for multiple sample estimation and inference.

            A detailed introduction to this command is given in \href{https://arxiv.org/abs/1906.00202}{Cattaneo, Farrell and Feng (2020b)}.

            For more details, and related Stata and R packages useful for empirical analysis,
            visit \url{https://sites.google.com/site/nppackages/}.
}
\details{
Companion command: \code{\link{lsprobust}} for partition-based least-squares regression
        estimation.
}
\examples{
x   <- runif(500)
y   <- sin(4*x)+rnorm(500)
est <- lsprobust(y, x)
lsprobust.plot(est)

}
\references{
Cattaneo, M. D., M. H. Farrell, and Y. Feng (2020a): \href{https://arxiv.org/abs/1804.04916}{Large Sample Properties of Partitioning-Based Series Estimators}. Annals of Statistics, 48(3): 1718-1741, 2020.

Cattaneo, M. D., M. H. Farrell, and Y. Feng (2020b): \href{https://arxiv.org/abs/1906.00202}{lspartition: Partitioning-Based Least Squares Regression}. R Journal, 12(1): 172-187, 2020.
}
\seealso{
\code{\link{lsprobust}}, \code{\link{lspkselect}}, \code{\link{lsplincom}}, \code{\link[ggplot2]{ggplot2}}.
}
\author{
Matias D. Cattaneo, Princeton University, Princeton, NJ. \email{cattaneo@princeton.edu}.

Max H. Farrell, University of California, Santa Barbara, CA. \email{maxhfarrell@ucsb.edu}.

Yingjie Feng (maintainer), Tsinghua University, Beijing, China. \email{fengyingjiepku@gmail.com}.
}
