% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crp_multiple.R
\name{crp_multiple}
\alias{crp_multiple}
\title{Conditional Response Probability for Multiple Lists}
\usage{
crp_multiple(data, position, answer, id, key, key.trial, id.trial, scored)
}
\arguments{
\item{data}{a dataframe of the scored free recall that you would
like to calculate - use prop_correct_free() for best formatting.}

\item{position}{a column name in the dataframe that contains
answered position of each response in quotes (i.e., "column")}

\item{answer}{a column name of the answer given for that position
in the original dataframe.}

\item{id}{a column name of the participant id in the original
dataframe.}

\item{key}{a vector containing the scoring key or data column name.
This column does not have to be included in the original dataframe.
We assume your answer key is in the tested position order. You should
not include duplicates in your answer key.}

\item{key.trial}{a vector containing the trial numbers for each answer.
Note: If you input long data (i.e., repeating trial-answer responses),
we will take the unique combination of the responses. If a trial number
is repeated, you will receive an error. Key and key.trial can also be
a separate dataframe, depending on how your output data is formatted.}

\item{id.trial}{a column name containing the trial numbers
for the participant data from the original dataframe. Note that
the free response "key" trial and this trial number should match.
The trial key will be repeated for each answer a participant gave.}

\item{scored}{a column in the original dataframe indicating if the
participant got the answer correct (1) or incorrect (0).}
}
\value{
\item{DF_CRP}{A dataframe of the proportion correct for each
conditional lag position including any other between subjects
variables present in the data.}
}
\description{
This function calculates the conditional response
probability of each lag position. Participants' lag
between subsequent named items is tallied and then
divided by the possible combination of subsequent lags
given their response pattern. This function was designed
to handle multiple or randomized lists across participants.
}
\details{
This output can then be used to create a CRP visualizations,
and an example can be found in our manuscript/vignettes.
}
\examples{

data("multi_data")
data("multi_answers")

DF_long <- arrange_data(data = multi_data,
                       responses = "Response",
                       sep = " ",
                       id = "Sub.ID",
                       repeated = "List.Number")

library(reshape)
multi_answers$position <- 1:nrow(multi_answers)
answer_long <- melt(multi_answers,
                    measured = colnames(multi_answers),
                    id = "position")
colnames(answer_long) <- c("position", "List.ID", "Answer")

answer_long$List.ID <- gsub(pattern = "List",
                            replacement = "",
                            x = answer_long$List.ID)

DF_long$response <- tolower(DF_long$response)
answer_long$Answer <- tolower(answer_long$Answer)
answer_long$Answer <- gsub(" ", "", answer_long$Answer)

scored_output <- prop_correct_multiple(data = DF_long,
                                    responses = "response",
                                    key = answer_long$Answer,
                                    key.trial = answer_long$List.ID,
                                    id = "Sub.ID",
                                    id.trial = "List.Number",
                                    cutoff = 1,
                                    flag = TRUE)

head(scored_output$DF_Scored)

head(scored_output$DF_Participant)


crp_output <- crp_multiple(data = scored_output$DF_Scored,
                          key = answer_long$Answer,
                          position = "position",
                          scored = "Scored",
                          answer = "Answer",
                          id = "Sub.ID",
                          key.trial = answer_long$List.ID,
                          id.trial = "List.Number")

 head(crp_output)

}
\keyword{correct}
\keyword{free}
\keyword{position}
\keyword{proportion}
\keyword{recall}
\keyword{scoring}
\keyword{serial}
