#' @keywords internal
loonGrob_name <- function(loon.grob) {
  obj <- character(0)
  class(obj) <- names(loon.grob$children)
  UseMethod("loonGrob_name", obj)
}
#' @keywords internal
loonGrob_name.default <- function(loon.grob) {
  name <- grobName(loon.grob)
  strsplit(name, split = "[.]")[[1]][2]
}
#' @keywords internal
loonGrob_name.l_plot <- function(loon.grob) "plot"
#' @keywords internal
loonGrob_name.l_hist <- function(loon.grob) "hist"
#' @keywords internal
loonGrob_name.l_graph <- function(loon.grob) "graph"
#' @keywords internal
loonGrob_name.l_serialaxes <- function(loon.grob) "serialaxes"
