% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lolog.R
\name{simulate.lolog}
\alias{simulate.lolog}
\title{Generates BinaryNetworks from a fit lolog object}
\usage{
\method{simulate}{lolog}(object, nsim = 1, seed = NULL, convert = FALSE, ...)
}
\arguments{
\item{object}{A `lolog` object.}

\item{nsim}{The number of simulated networks}

\item{seed}{Either NULL or an integer that will be used in a call to set.seed before simulating}

\item{convert}{convert to a network object#'}

\item{...}{unused}
}
\value{
A list of BinaryNet (or network if convert=TRUE) objects. Networks contain an additional
vertex covariate "__order__" that indicates the sequence order in which the vertex was 'added' 
into the network.
}
\description{
Generates BinaryNetworks from a fit lolog object
}
\examples{
library(network)
data(flo)
flomarriage <- network(flo,directed=FALSE)
flomarriage \%v\% "wealth" <- c(10,36,27,146,55,44,20,8,42,103,48,49,10,48,32,3)
fit <- lolog(flomarriage ~ edges + nodeCov("wealth"))
net <- simulate(fit)[[1]]
plot(net)

}
