% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bible.R
\name{get_fraction}
\alias{get_fraction}
\title{Get Fraction of a Chapter or Book}
\usage{
get_fraction(book, chapter, fraction, part, language = NULL, testament = NULL)
}
\arguments{
\item{book}{A character string or vector specifying the book(s) from which the chapter is retrieved.}

\item{chapter}{A numeric vector indicating the chapter number(s) to be processed.}

\item{fraction}{A numeric value representing the total number of sections into which the chapter should be divided.
Must be an integer greater than or equal to 1.}

\item{part}{A numeric value indicating which section of the divided chapter to return.
Must satisfy \code{1 <= part <= fraction}.}

\item{language}{An optional character string indicating the language of the Bible.
Typically one of \code{"English"}, \code{"Hebrew"}, or \code{"Greek"}. Default is \code{NULL}.}

\item{testament}{An optional character string specifying the testament.
Should be \code{"Old Testament"}, \code{"New Testament"}, or \code{"Both"}. Default is \code{NULL}.}
}
\value{
A character vector containing the verses from the specified section of the chapter.
}
\description{
Extracts a specified fraction of a chapter from a given book or a portion of a book.
}
\details{
This function validates the \code{fraction} and \code{part} parameters, retrieves the full chapter text using
\code{retrieve_chapter()}, and calculates the corresponding section of the chapter to return. The chapter is divided
into equal parts based on the number of verses, and the function extracts the verses corresponding to the requested part.
}
\keyword{internal}
