% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{layouts}
\alias{layouts}
\alias{default_log_layout}
\alias{simple_log_layout}
\alias{bare_log_layout}
\alias{logfmt_log_layout}
\alias{json_log_layout}
\title{Layouts}
\usage{
default_log_layout(time_format = "\%Y-\%m-\%d \%H:\%M:\%S")

simple_log_layout()

bare_log_layout()

logfmt_log_layout()

json_log_layout()
}
\arguments{
\item{time_format}{A valid format string for timestamps. See
\code{\link[base:strptime]{base::strptime()}}. For some layouts this can be \code{NA} to elide the
timestamp.}
}
\description{
In \href{https://logging.apache.org/log4j/}{log4j} etymology, \strong{Layouts} are how
\strong{\link[=appenders]{Appenders}} control the format of messages.

Some general-purpose layouts are described below.

For implementing your own layouts, see Details.
}
\details{
Layouts are implemented as functions with the interface
\verb{function(level, ...)} and returning a single string.

\code{json_log_layout} requires the \code{jsonlite} package.
}
\examples{
# The behaviour of a layout can be seen by using them directly:
simple <- simple_log_layout()
simple("INFO", "Input has length ", 0, ".")

with_timestamp <- default_log_layout()
with_timestamp("INFO", "Input has length ", 0, ".")

}
