% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_surface}
\alias{plot_surface}
\title{Plot the surface and observations}
\usage{
plot_surface(
  est_list,
  GIA_fn = base_GIA,
  fn_list = NULL,
  xlab = "Dose A",
  ylab = "Dose B",
  title = "Surface Plot of Doses",
  subtitle = "",
  base_size = 14
)
}
\arguments{
\item{est_list}{output from \code{estimate_params}}

\item{GIA_fn}{function to calculate GIA}

\item{fn_list}{additional arguments to pass to GIA fn}

\item{xlab}{to pass to ggplot}

\item{ylab}{to pass to ggplot}

\item{title}{to pass to ggplot}

\item{subtitle}{to pass to ggplot}

\item{base_size}{to pass to ggplot}
}
\value{
ggplot object
}
\description{
Plot the surface and observations
}
\examples{
df <- loewesadditivity::cyrpa_ripr
df$dose_A <- df$CyRPA
df$dose_B <- df$RIPR
data <- fortify_gia_data(df)
model_params <- c("beta_A" = .5, "beta_B" = .5,
                 "gamma_A" = .5, "gamma_B" = .5,
                 "tau_1" = 0, "tau_2" = 0)
n_boot <- 10
GIA_fn <- base_GIA
S_fn <- calc_S_base
fn_list <- NULL
alpha <- .05
verbose <- FALSE
out <- estimate_params(data = data,
init_params = model_params,
n_boot = n_boot,
GIA_fn = GIA_fn,
S_fn = S_fn,
fn_list = fn_list,
alpha = alpha,
verbose = verbose)
plot_surface(out)
}
