% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{boot_GIA}
\alias{boot_GIA}
\title{Helper function for the bootstrap results}
\usage{
boot_GIA(
  par,
  gia_df,
  gia_est,
  n_boot = 100,
  alpha = 0.05,
  GIA_fn = base_GIA,
  S_fn = calc_S_base,
  fn_list = NULL,
  verbose = FALSE
)
}
\arguments{
\item{par}{named vector of parameters, that correspond to those used in 'GIA_fn'.}

\item{gia_df}{data frame with the following columns
\itemize{
\item{dose_A}{dose A mg/mL}
\item{dose_B}{dose B mg/mL}
\item{GIA}{GIA}
}}

\item{gia_est}{estimated values of GIA (these will be used as the 'truth')}

\item{n_boot}{number of boot straps to use to estimate confidence intervals of the parameters, GIA estimates, and values of S.  The default is 100.  If n_boot = 0, then no bootstraps will be run and only the point estimates will be returned.}

\item{alpha}{value of alpha.  Default is .05}

\item{GIA_fn}{function to calculate the GIA from dose_A and dose_B combinations and given set of parameters.  Default is base_GIA}

\item{S_fn}{Function to calculate S. Default is calc_S_base}

\item{fn_list}{additional arguments to pass to GIA_fn}

\item{verbose}{logical indicating whether we should print where we are in the process.  Default is FALSE.}
}
\value{
a list with the following elements
\itemize{
\item{params_est}{a data frame of dimension # of params x 4 where each row in the data frame is a parameter and where the columns are the mean, lower, alpha/2 quantile,and upper,100 - alpha/2 quantile}
\item{S_est}{ a data frame of one row  x 4 where we provide the mean, lower, and upper estimates}
\item{GIA_est}{the original data with additional columns of the mean, lower, and upper estimates for each dose combination}

}
}
\description{
Helper function for the bootstrap results
}
