% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDijkstra.R
\name{plotDijkstra}
\alias{plotDijkstra}
\title{Plot shortest path between two points in a network}
\usage{
plotDijkstra(edgeMatrix, coordMatrix, dijkstraPath)
}
\arguments{
\item{edgeMatrix}{A matrix containing zeros and ones if an edge between two vertexes is absent or not}

\item{coordMatrix}{A data frame containing the x and y coordinates of each vertex of the network}

\item{dijkstraPath}{A vector of numbers corresponding to the vertexes of the shortest path through the network}
}
\value{
Function outputs a two-dimensional plot
}
\description{
This function plots the entire network and shortest path between two points. The parameter
dijkstraPath is obtained by the function dijkstra, in which one has to specify the initial and end node of
the path.
}
\examples{
edgeMatrix <- matrix(0, nrow = 4, ncol = 4)
edgeMatrix[,1] <- c(0,1,0,0)
edgeMatrix[,2] <- c(1,0,1,1)
edgeMatrix[,3] <- c(0,1,0,0)
edgeMatrix[,4] <- c(0,1,0,0)
coordMatrix <- matrix(c(0,10,15,20,30,30,15,15),ncol = 2)
dijkstraPath <- c(4,2,1)
plotDijkstra(edgeMatrix, coordMatrix, dijkstraPath)

}
