% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locStra.r
\name{bed_fastGrmEVs}
\alias{bed_fastGrmEVs}
\title{Computation of the k leading eigenvectors of the genomic relationship matrix, defined in Yang et al. (2011), directly from a bed+bim+fam file.}
\usage{
bed_fastGrmEVs(f, k, robust = TRUE, q = 2)
}
\arguments{
\item{f}{The filename of the bed file (including its extension). The bim and fam files need to be in the same folder and have the same base filename.}

\item{k}{The number of leading eigenvectors.}

\item{robust}{Flag to indicate if the classic (\code{robust=FALSE}) or robust (\code{robust=TRUE}) version of the genomic relationship matrix is desired. Default is \code{robust=TRUE}.}

\item{q}{The number of power iteration steps (default is \code{q=2}).}
}
\value{
The k leading eigenvectors of the genomic relationship matrix of \code{m} as a column matrix.
}
\description{
Computation of the k leading eigenvectors of the genomic relationship matrix, defined in Yang et al. (2011), directly from a bed+bim+fam file.
}
\examples{
require(locStra)

}
\references{
Yang J, Lee SH, Goddard ME, Visscher PM (2011). GCTA: a tool for genome-wide complex trait analysis. Am J Hum Genet, 88(1):76-82.

N. Halko, P.G. Martinsson, and J.A. Tropp (2011). Finding Structure with Randomness: Probabilistic Algorithms for Constructing Approximate Matrix Decompositions. SIAM Review: 53(2), pp. 217--288.

F. Prive, M. Blum, H. Aschard, B.J. Vilhjalmsson (2022). bigsnpr: Analysis of Massive SNP Arrays. https://cran.r-project.org/package=bigsnpr
}
