% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmForc_transform.R
\name{transform_byh}
\alias{transform_byh}
\title{Convert a list of time format Forecast objects to a list of h_ahead format
Forecast objects.}
\usage{
transform_byh(forcs, h_aheads)
}
\arguments{
\item{forcs}{List of Forecast objects.}

\item{h_aheads}{Vector of h_ahead values that is equal in length to the
number of Forecast objects in forcs.}
}
\value{
List of Forecast objects in h_ahead format.
}
\description{
Given a list of forecasts with homogenous origin or future values, converts
all forecasts in the list to h_ahead format.
}
\examples{

# The following forecasts are in time format. Each forecast was made at a
# different time and represents a forecast for a number of h_ahead periods 
# ahead.

forc1_t1 <- Forecast(
  origin = as.Date(c("2010-02-17", "2010-02-17", "2010-02-17")),
  future = as.Date(c("2010-06-30", "2010-09-30", "2010-12-31")),
  forecast = c(4.27, 3.77, 3.52),
  realized = c(4.96, 4.17, 4.26),
  h_ahead = NA
)

forc1_t2 <- Forecast(
  origin = as.Date(c("2010-05-14", "2010-05-14", "2010-05-14")),
  future = as.Date(c("2010-09-30", "2010-12-31", "2011-03-31")),
  forecast = c(3.36, 3.82, 4.22),
  realized = c(4.17, 4.26, 4.99),
  h_ahead = NA
)

forc1_t3 <- Forecast(
  origin = as.Date(c("2010-07-22", "2010-07-22", "2010-07-22")),
  future = as.Date(c("2010-12-31", "2011-03-31", "2011-06-30")),
  forecast = c(4.78, 4.53, 5.03),
  realized = c(4.26, 4.99, 5.33),
  h_ahead = NA
)

forc1_t4 <- Forecast(
  origin = as.Date(c("2010-12-22", "2010-12-22", "2010-12-22")),
  future = as.Date(c("2011-03-31", "2011-06-30", "2011-09-30")),
  forecast = c(5.45, 4.89, 5.78),
  realized = c(4.99, 5.33, 5.21),
  h_ahead = NA
)

forcs <- list(forc1_t1, forc1_t2, forc1_t3, forc1_t4)

transform_byh(forcs, h_aheads = c(1, 2, 3))

}
