% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_interactive_tour.R
\name{load_interactive_tour}
\alias{load_interactive_tour}
\title{R Wrapper for 'load_interactive_tour' Function Written in 'python'}
\usage{
load_interactive_tour(
  data,
  directory_to_save,
  half_range = NULL,
  n_plot_cols = 2,
  preselection = FALSE,
  preselection_names = FALSE,
  n_subsets = FALSE,
  display_size = 5,
  hover_cutoff = 10,
  label_size = 15,
  color_scale = "default",
  color_scale_heatmap = "default",
  axes_blendout_threshhold = 1
)
}
\arguments{
\item{data}{the dataset you want to investigate. Must be the same as the
dataset that was loaded when the save was created!}

\item{directory_to_save}{path to the location of the save folder}

\item{half_range}{factor that influences the scaling of the displayed tour plots.
Small values lead to more spread out datapoints (that might not fit the plotting area),
while large values lead to the data being more compact. If not provided a good estimate
will be calculated and used.}

\item{n_plot_cols}{specifies the number of columns of the grid of the final display.}

\item{preselection}{a vector that specifies in which subset each datapoint should be put initially.}

\item{preselection_names}{a vector that specifies the names of the preselection subsets}

\item{n_subsets}{the total number of available subsets (up to 10).}

\item{display_size}{rough size of each subplot in inches}

\item{hover_cutoff}{number of features at which the switch from intransparent
to transparent labels that can be hovered over to make them intransparent occurs}

\item{label_size}{size of the labels of the feature names of 1d and 2d tours}

\item{color_scale}{a viridis/matplotlib colormap to define the color scheme of the subgroups}

\item{color_scale_heatmap}{a viridis/matplotlib colormap to define the color scheme of the heatmap}

\item{axes_blendout_threshhold}{initial value of the threshold for blending
out projection axes with a smaller length}
}
\value{
opens the interactive GUI
}
\description{
Loads a previously saved snapshot created by pressing the "Save projections
and subsets" within the GUI. The data that was loaded when saving a
snapshot has to be provided to this function when loading that snapshot.
Additionally, this function allows to adjust some parameters of the GUI when
loading a snapshot, such as display_size or label_size.
}
\examples{
data("flea", package = "tourr")
data <- flea[1:6]

if (check_venv()){
init_env(env_name = "r-lionfish", virtual_env = "virtual_env")
} else if (check_conda_env()){
init_env(env_name = "r-lionfish", virtual_env = "anaconda")
}

pytourr_dir <- find.package("lionfish", lib.loc = NULL, quiet = TRUE)
pytourr_dir <- paste(pytourr_dir, "/inst/test_snapshot", sep = "")
if (interactive()){
load_interactive_tour(data, pytourr_dir)
}
}
