% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_histories.R
\name{get_guided_lda_history}
\alias{get_guided_lda_history}
\title{Get Guided Tour-LDA History}
\usage{
get_guided_lda_history(data, clusters, dimension)
}
\arguments{
\item{data}{the dataset to calculate the projections with}

\item{clusters}{the clusters for the lda to be performed on}

\item{dimension}{1 for a 1d tour or 2 for a 2d tour}
}
\value{
history object containing the projections of the requested tour
}
\description{
Returns a guided tour with the LDA index to the python' backend. This
guided tour is generated with the 'tourr' functions 'save_history' and
'guided_tour'.
}
\examples{
data("flea", package = "tourr")
clusters <- as.numeric(factor(flea[[7]]))
get_guided_lda_history(flea[-7], clusters, 2)

}
