% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/include_graphics2.R
\name{include_graphics2}
\alias{include_graphics2}
\title{Wrapper of \code{knitr::include_graphics} to Deal with URLs and Invalid File Types}
\usage{
include_graphics2(path, alt_path = NULL, handler = function(path)
  knitr::asis_output(paste("View", tools::file_ext(path), "at", path)),
  ...)
}
\arguments{
\item{path}{String. Path to a figure to be included. Can be either
an URL or a local path.}

\item{alt_path}{String. An alternative figure path for \code{path}
with invalid extensions. In the case of PDF ('LaTeX') output,
invalid extensions are \code{.gif}, \code{.svg}.}

\item{handler}{Function. A function with a single argument \code{path}.
Used to insert alternative contents, such as a piece of text,
when the figure cannot be inserted.}

\item{...}{Other arguments to pass to
\code{\link[knitr]{include_graphics}}.}
}
\description{
Deals with URL paths and invalid file types passed to \code{path}
of \code{\link[knitr]{include_graphics}}. When the output format
of the R Markdown is \code{PDF}, and an URL is passed to
\code{path}, the figure is automatically downloaded from the URL
and included using the local relative path.
If a figure has an invalid file extension for PDF output
(e.g. \code{.gif}, \code{.svg}), the function passed to
\code{handler} is used to override the default behavior:
inserting figures with \code{knitr::include_graphics}.
}
\details{
Read more about using the function at
  \url{http://bit.ly/include_graphics2}.
}
\examples{
png_url <- 'https://commonmark.org/images/markdown-mark.png'
gif_url <- 'https://media.giphy.com/media/k3dcUPvxuNpK/giphy.gif'

\dontrun{
include_graphics2(gif_url, alt_path = png_url)
}

}
