% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.histogram.R
\name{likert.histogram.plot}
\alias{likert.histogram.plot}
\title{Histogram of number of responses.}
\usage{
likert.histogram.plot(
  l,
  xlab = "n",
  plot.missing = TRUE,
  bar.color = "grey70",
  missing.bar.color = "maroon",
  label.completed = "Completed",
  label.missing = "Missing",
  legend.position = "bottom",
  wrap = ifelse(is.null(l$grouping), 50, 100),
  order,
  group.order,
  panel.arrange = "v",
  panel.strip.color = "#F0F0F0",
  text.size = 2.5,
  ...
)
}
\arguments{
\item{l}{results of \code{\link{likert}}.}

\item{xlab}{label used for the x-axis.}

\item{plot.missing}{if TRUE, missing values will be plotted to the left of the
x-axis.}

\item{bar.color}{the bar color.}

\item{missing.bar.color}{the color of the bar for missing values.}

\item{label.completed}{the label to use in the legend representing the count of
complete values.}

\item{label.missing}{the label to use in the legend representing the count of
missing values.}

\item{legend.position}{location of the legend.}

\item{wrap}{number of characters before warping the text in the panel strips.}

\item{order}{the order of the items.}

\item{group.order}{the order in which groups (for grouped items) or items
(for non-grouped items) should be plotted.}

\item{panel.arrange}{v for vertical or h for horizontal.}

\item{panel.strip.color}{the color for panels.}

\item{text.size}{text size.}

\item{...}{other ggplot2 parameters.}
}
\description{
Plots a histogram of the number of responses for each item and group (if specified).
Negative values (in maroon by default) indicate the number of missing values
for that item and group.
}
