% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-functions.R
\name{train_test_split}
\alias{train_test_split}
\title{Dataset splitting}
\usage{
train_test_split(
  data,
  test_size = 0.3,
  random_state = NULL,
  y_index = ncol(data)
)
}
\arguments{
\item{data}{Dataset that is going to be split}

\item{test_size}{Represents the proportion of the dataset to include in the test split.
Should be between 0.0 and 1.0 (defaults to 0.3)}

\item{random_state}{Controls the shuffling applied to the data before applying the split.
Pass an int for reproducible output across multiple function calls (defaults to NULL)}

\item{y_index}{Corresponding column index of the response variable \strong{y} (defaults to last column of \strong{data})}
}
\value{
A \code{list} of length 4 with elements:\tabular{ll}{
\code{X_train} \tab Training input variables  \cr
\tab \cr
\code{X_test} \tab Test input variables \cr
\tab \cr
\code{y_train} \tab Training response variables   \cr
\tab \cr
\code{y_test} \tab Test response variables \cr
}
}
\description{
Split dataframes or matrices into random train and test subsets. Takes the column at the \strong{y_index} of \strong{data} as response variable \strong{(y)}
and the rest as the independent variables \strong{(X)}
}
\examples{
data(abalone)
split_list <- train_test_split(abalone, test_size =  0.3)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

print(head(X_train))
print(head(X_test))
print(head(y_train))
print(head(y_test))
}
