% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering-methods.R
\name{KMeans}
\alias{KMeans}
\title{KMeans Clustering}
\value{
R6 Class of KMeans
}
\description{
Wrapper R6 Class of stats::kmeans function that can be used for LESSRegressor and LESSClassifier
}
\examples{

## ------------------------------------------------
## Method `KMeans$new`
## ------------------------------------------------

km <- KMeans$new()
km <- KMeans$new(n_clusters = 10)
km <- KMeans$new(n_clusters = 10, random_state = 100)

## ------------------------------------------------
## Method `KMeans$fit`
## ------------------------------------------------

data(abalone)
km <- KMeans$new()
km$fit(abalone[1:100,])

## ------------------------------------------------
## Method `KMeans$get_cluster_centers`
## ------------------------------------------------

print(km$get_cluster_centers())

## ------------------------------------------------
## Method `KMeans$get_labels`
## ------------------------------------------------

print(km$get_labels())
}
\seealso{
\code{\link[stats:kmeans]{stats::kmeans()}}
}
\section{Super class}{
\code{\link[less:BaseEstimator]{less::BaseEstimator}} -> \code{KMeans}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-KMeans-new}{\code{KMeans$new()}}
\item \href{#method-KMeans-fit}{\code{KMeans$fit()}}
\item \href{#method-KMeans-get_cluster_centers}{\code{KMeans$get_cluster_centers()}}
\item \href{#method-KMeans-get_labels}{\code{KMeans$get_labels()}}
\item \href{#method-KMeans-clone}{\code{KMeans$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_all_fields"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_all_fields'><code>less::BaseEstimator$get_all_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_attributes"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_attributes'><code>less::BaseEstimator$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="set_random_state"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-set_random_state'><code>less::BaseEstimator$set_random_state()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KMeans-new"></a>}}
\if{latex}{\out{\hypertarget{method-KMeans-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of R6 Class of KMeans
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KMeans$new(n_clusters = 8, n_init = 10, max_iter = 300, random_state = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_clusters}}{the number of clusters. A random set of (distinct) rows in X is chosen as the initial centres (default to 8)}

\item{\code{n_init}}{how many random sets should be chosen? (default to 10)}

\item{\code{max_iter}}{the maximum number of iterations allowed (default to 300).}

\item{\code{random_state}}{seed number to be used for fixing the randomness (default to NULL).}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{km <- KMeans$new()
km <- KMeans$new(n_clusters = 10)
km <- KMeans$new(n_clusters = 10, random_state = 100)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KMeans-fit"></a>}}
\if{latex}{\out{\hypertarget{method-KMeans-fit}{}}}
\subsection{Method \code{fit()}}{
Perform k-means clustering on a data matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KMeans$fit(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{numeric matrix of data, or an object that can be coerced to such a matrix (such as a numeric vector or a data frame with all numeric columns).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Fitted R6 class of KMeans() that has 'cluster_centers' and 'labels' attributes
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(abalone)
km <- KMeans$new()
km$fit(abalone[1:100,])
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KMeans-get_cluster_centers"></a>}}
\if{latex}{\out{\hypertarget{method-KMeans-get_cluster_centers}{}}}
\subsection{Method \code{get_cluster_centers()}}{
Auxiliary function returning the cluster centers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KMeans$get_cluster_centers()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{print(km$get_cluster_centers())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KMeans-get_labels"></a>}}
\if{latex}{\out{\hypertarget{method-KMeans-get_labels}{}}}
\subsection{Method \code{get_labels()}}{
Auxiliary function returning a vector of integers (from 1:k) indicating the cluster to which each point is allocated.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KMeans$get_labels()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{print(km$get_labels())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KMeans-clone"></a>}}
\if{latex}{\out{\hypertarget{method-KMeans-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KMeans$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
