% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array-lenses.R
\name{slice_l}
\alias{slice_l}
\title{Slice lens}
\usage{
slice_l(dimension, slice, drop = FALSE)
}
\arguments{
\item{dimension}{the dimension to slice}

\item{slice}{the slice index}

\item{drop}{whether or not to drop dimensions with length 1.
Only applies to \link{view}.}
}
\description{
Create a lens into a specific slice of a specific
dimension of a multidimensional object. Not to be
confused with dplyr slice.
}
\examples{
(x <- matrix(1:4, ncol = 2))
view(x, slice_l(1, 2)) # x[2,, drop = FALSE]
view(x, slice_l(2, 2)) # x[,2, drop = FALSE]
set(x, slice_l(1,1), c(10,20))
}
