% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_profession.R
\name{get_profession}
\alias{get_profession}
\title{Fetch 'Professions' table}
\format{
Data frame in wide format with columns (varies by legislature):
\itemize{
\item{wikidataid: Wikidata ID identifying a legislator's Wikidata entry (of class \sQuote{character}).}
\item{occupation_1: occupation a legislator practiced or was trained in (of class \sQuote{logical}).}
\item{occupation_2: ... (of class \sQuote{logical}).}
\item{...}
}
}
\source{
Wikidata API, \url{https://www.wikidata.org/wiki/Wikidata:Main_Page}
}
\usage{
get_profession(legislature)
}
\arguments{
\item{legislature}{A character string specifying the three-letter country code of the legislature for which data shall be fetched. Currently one of \sQuote{aut}, \sQuote{can}, \sQuote{cze}, \sQuote{esp}, \sQuote{fra}, \sQuote{deu}, \sQuote{irl}, \sQuote{sco}, \sQuote{gbr}, \sQuote{usa_house}, or \sQuote{usa_senate}.}
}
\value{
A data frame with columns as specified above.
}
\description{
Fetches occupational data of legislators for the specified legislature. Requires a working Internet connection.
}
\examples{
\donttest{# Get entire 'Professions' table for the United States House
usa_offices <- get_office(legislature = "usa_house")
tibble::glimpse(usa_offices)

# Get 'Professions' table for female members of the United States House
usa_offices_subset <- dplyr::semi_join(x = usa_offices,
                                       y = dplyr::filter(get_core(legislature = "usa_house"),
                                                         sex == "female"),
                                       by = "wikidataid")
tibble::glimpse(usa_offices_subset)
}
}
