% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probnormal.R
\name{probnormal}
\alias{probnormal}
\title{Undertanding the probability of the normal distribution}
\usage{
probnormal(
  a = 1,
  b = 2,
  col = "lightblue",
  mean = 0,
  sd = 1,
  type = 1,
  rounding = 4,
  zang = 0,
  xang = 0
)
}
\arguments{
\item{a}{lower limit. The default is \code{1}.}

\item{b}{upper limit. The default is \code{2}, and \code{b} must be greater than \code{a}.}

\item{col}{plot color. The default is \code{col = "lightblue"}.}

\item{mean}{parameter. The default is \code{0}.}

\item{sd}{parameter. The default is \code{1}.}

\item{type}{type of visualization of the probability region plot. Default is \code{1}, others: \code{2, 3, 4, 5, 6}. See Details.}

\item{rounding}{Numerical object. Rounds the values in its first argument to the specified number of decimal places (default \code{4}).}

\item{zang}{Angle of the values on the Z-axis. Default is \code{zang = 0}.}

\item{xang}{Angle of the values on the X-axis. Default is \code{xang = 0}.}
}
\description{
Using a graphical visualization, it is possible to understand the probabilities
involved in a normal distribution.
}
\details{
\itemize{
\item \verb{type = 1,2}: \code{a} and \code{b} must be greater than \code{mean};
\item \verb{type = 3,4}: \code{a} and \code{b} must be less than \code{mean};
\item \verb{type = 5,6}: \code{a} and \code{b} can be any real value.
}
}
\examples{
\dontrun{
probnormal(type = 2)
probnormal(-1, 0, type = 3)
probnormal(-1, 0, type = 4)
probnormal(-1, 0, type = 5)
probnormal(-1, 2, type = 5)
probnormal(1, 2, type = 5)
probnormal(1, 2, type = 6)
}


}
