% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PDI_validation.R
\name{PDI_validation}
\alias{PDI_validation}
\title{Calculate the similarity of a least-cost path to a known route}
\usage{
PDI_validation(lcp, comparison)
}
\arguments{
\item{lcp}{\code{sf}}

\item{comparison}{\code{sf}}
}
\value{
\code{sf} POLYGON of the area between the lcp and comparison with data.frame of area, pdi, max distance, and normalised pdi
}
\description{
Calculates the similarity of a least-cost path to a known route using the path deviation index method proposed by Jan et al. (1999)
}
\details{
The Path Deviation Index (pdi) measures the spatial separation between a pair of paths and aims to overcome the shortcomings of measuring the percentage of coverage of a least cost path from a comparison path (e.g. as implemented in the buffer_validation function).

The pdi index is defined as the area between paths divided by the Euclidean distance of the shortest path between the origin and destination of the paths. The index can be interpreted as the average distance between the paths.

\code{pdi  = area / length}

The value of the pdi depends on the length of the path and makes comparison of pdis difficult for paths with different origins and destinations. This is overcome by normalising the pdi by the Euclidean distance of the shortest path between the origin and destination of the paths

\code{Normalised pdi = pdi / length * 100}

The normalised pdi is the percent of spatial separation between the two paths over the shortest path. For example, if a normalised pdi is 30 percent, it means that the average distance between two paths is 30 percent of the length of the shortest path. With normalised pdi, the spatial separations of all paths  can be compared regardless of the length of the shortest path.

Note: If the lcp path has a different origin and destination than the comparison path, the origin and destination of the lcp path are replaced with the origin and destination of the comparison path. This to ensure that a polygon can be created between the two paths which is required for calculating the area of spatial separation.
}
\examples{

r <- terra::rast(system.file("extdata/SICILY_1000m.tif", package="leastcostpath"))

slope_cs <- create_slope_cs(x = r, cost_function = "tobler", neighbours = 4)

locs <- sf::st_sf(geometry = sf::st_sfc(
sf::st_point(c(839769, 4199443)),
sf::st_point(c(1038608, 4100024)),
crs = terra::crs(r)))

lcp1 <- create_lcp(x = slope_cs, origin = locs[1,], destination = locs[2,], 
cost_distance = TRUE)

lcp2 <- create_lcp(x = slope_cs, origin = locs[2,], destination = locs[1,], 
cost_distance = TRUE)

pdi_val <- PDI_validation(lcp = lcp1, comparison = lcp2)
}
\author{
Joseph Lewis
}
