% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldhmm-df2ts-method.R
\name{ldhmm.df2ts}
\alias{ldhmm.df2ts}
\title{Utility to standardize timeseries from data.frame to xts}
\usage{
ldhmm.df2ts(
  df,
  date_format = "\%m/\%d/\%Y",
  dt = "Date",
  col_in = "Close",
  col_out = "Close",
  do.logr = TRUE,
  rnd.zero = 0.01
)
}
\arguments{
\item{df}{Data.frame of the time serie}

\item{date_format}{Character, date format of the input date column. 
It can be NULL to indicate no date conversion is needed.
Default: "\code{\%m/\%d/\%Y}".}

\item{dt}{Character, the name of the input date column. Default: "Date"}

\item{col_in}{Character, the name of the input closing price column. Default: "Close"}

\item{col_out}{Character, the name of the output closing price column. Default: "Close"}

\item{do.logr}{logical, if \code{TRUE} (default), produce xts object of logr; otherwise, just the \code{col_out} column.}

\item{rnd.zero}{numeric, a small random factor (scaled to sd of logr) to avoid an unreal peak of zero log-returns.}
}
\value{
The xts object for the time series
}
\description{
This utility converts the df input to an xts object with columns
and statistics required for the fitting/plot utility in the ecd package.
The require columns are Date, Close, logr. This utility can also be used
to convert the input from Quandl.
}
\examples{
\dontrun{
ldhmm.df2ts(df)
}
}
\keyword{sample-data}
\keyword{timeseries}
\keyword{xts}
