% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsTopics.R
\name{jsTopics}
\alias{jsTopics}
\title{Pairwise Jensen-Shannon Similarities (Divergences)}
\usage{
jsTopics(topics, epsilon = 1e-06, progress = TRUE, pm.backend, ncpus)
}
\arguments{
\item{topics}{[\code{named matrix}]\cr
The counts of vocabularies/words (row wise) in topics (column wise).}

\item{epsilon}{[\code{numeric(1)}]\cr
Numerical value added to \code{topics} to ensure computability. See details.
Default is \code{1e-06}.}

\item{progress}{[\code{logical(1)}]\cr
Should a nice progress bar be shown? Turning it off, could lead to significantly
faster calculation. Default is \code{TRUE}.
If \code{pm.backend} is set, parallelization is done and no progress bar will be shown.}

\item{pm.backend}{[\code{character(1)}]\cr
One of "multicore", "socket" or "mpi".
If \code{pm.backend} is set, \code{\link[parallelMap]{parallelStart}} is
called before computation is started and \code{\link[parallelMap]{parallelStop}}
is called after.}

\item{ncpus}{[\code{integer(1)}]\cr
Number of (physical) CPUs to use. If \code{pm.backend} is passed,
default is determined by \code{\link[future]{availableCores}}.}
}
\value{
[\code{named list}] with entries
\describe{
  \item{\code{sims}}{[\code{lower triangular named matrix}] with all pairwise
  similarities of the given topics.}
  \item{\code{wordslimit}}{[\code{integer}] = vocabulary size. See
  \code{\link{jaccardTopics}} for original purpose.}
  \item{\code{wordsconsidered}}{[\code{integer}] = vocabulary size. See
  \code{\link{jaccardTopics}} for original purpose.}
  \item{\code{param}}{[\code{named list}] with parameter specifications for
  \code{type} [\code{character(1)}] \code{= "Cosine Similarity"} and
  \code{epsilon} [\code{numeric(1)}]. See above for explanation.}
}
}
\description{
Calculates the similarity of all pairwise topic combinations using the
Jensen-Shannon Divergence.
}
\details{
The Jensen-Shannon Similarity for two topics \eqn{\bm z_{i}} and
\eqn{\bm z_{j}} is calculated by
\deqn{JS(\bm z_{i}, \bm z_{j}) = 1 - \left( KLD\left(\bm p_i, \frac{\bm p_i + \bm p_j}{2}\right) + KLD\left(\bm p_j, \frac{\bm p_i + \bm p_j}{2}\right) \right)/2}
\deqn{= 1 - KLD(\bm p_i, \bm p_i + \bm p_j)/2 - KLD(\bm p_j, \bm p_i + \bm p_j)/2 - \log(2)}
with \eqn{V} is the vocabulary size, \eqn{\bm p_k = \left(p_k^{(1)}, ..., p_k^{(V)}\right)},
and \eqn{p_k^{(v)}} is the proportion of assignments of the
\eqn{v}-th word to the \eqn{k}-th topic. KLD defines the Kullback-Leibler
Divergence calculated by
\deqn{KLD(\bm p_{k}, \bm p_{\Sigma}) = \sum_{v=1}^{V} p_k^{(v)} \log{\frac{p_k^{(v)}}{p_{\Sigma}^{(v)}}}.}

There is an \code{epsilon} added to every \eqn{n_k^{(v)}}, the count
(not proportion) of assignments to ensure computability with respect to zeros.
}
\examples{
res = LDARep(docs = reuters_docs, vocab = reuters_vocab, n = 4, K = 10, num.iterations = 30)
topics = mergeTopics(res, vocab = reuters_vocab)
js = jsTopics(topics)
js

sim = getSimilarity(js)
dim(sim)

js1 = jsTopics(topics, epsilon = 1)
sim1 = getSimilarity(js1)
summary((sim1-sim)[lower.tri(sim)])
plot(sim, sim1, xlab = "epsilon = 1e-6", ylab = "epsilon = 1")

}
\seealso{
Other TopicSimilarity functions: 
\code{\link{cosineTopics}()},
\code{\link{dendTopics}()},
\code{\link{getSimilarity}()},
\code{\link{jaccardTopics}()},
\code{\link{rboTopics}()}
}
\concept{TopicSimilarity functions}
