% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_find_file_with_code.R
\name{util_find_file_with_code}
\alias{util_find_file_with_code}
\title{R function to find file with specific code within it's content}
\usage{
util_find_file_with_code(
  files,
  code_to_find,
  option_replace = FALSE,
  v_settings,
  v_values
)
}
\arguments{
\item{files}{\itemize{
\item string, vector with file paths
}}

\item{code_to_find}{\itemize{
\item string or integer with a pattern value to search within the file
}}

\item{option_replace}{boolean, option to indicate if function should also replace parameter values}

\item{v_settings}{string vector with the parameters that needs to be found}

\item{v_values}{vector with the corresponding values of the parameters}
}
\value{
string with a file path containing a code
}
\description{
Utility function to find the file path which contains specific code

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
Function is reading content of file and checks each file for a specific code
Function will require a vector with a valid file paths
Function will output the path to that file which contains a give code
If no desired code is found, function will return NULL
Optionally, if enabled, function will replace their values
Note: supply same kind of parameters (either boolean or integers)
}
\examples{

library(readr)

dir <- normalizePath(tempdir(),winslash = "/")

file.copy(from = system.file("extdata/default", package = "lazytrade"),
          to = dir, recursive = TRUE)

files_chr <- list.files(path = file.path(dir, "default"), all.files = TRUE,
pattern = ".chr", full.names = TRUE)
code_to_find <- 9142301

# find the path to the file with numeric code
file_i_need <- util_find_file_with_code(files = files_chr, 
                                   code_to_find = 9142301)

# find the path to the file with a character code
file_i_need <- util_find_file_with_code(files = files_chr,
                                   code_to_find = 'BITCOIN')
                                   
# find the path to the file with a character code that is not exists in those files
file_i_need <- util_find_file_with_code(files = files_chr,
                                   code_to_find = 'Banana')
                                   
# define a vector with settings to search
v_par <- c("StartHour")
v_val <- c(15)
                                    
# Replace integer values
file_i_need <- util_find_file_with_code(files = files_chr,
                                   code_to_find = 9142301,
                                   option_replace = TRUE,
                                   v_settings = v_par,
                                   v_values = v_val)
                                   
# define a vector with settings to search
v_par <- "UseMAFilter"
v_val <- FALSE
                                     
# Replace boolean values
file_i_need <- util_find_file_with_code(files = files_chr,
                                   code_to_find = 9142301,
                                   option_replace = TRUE,
                                   v_settings = v_par,
                                   v_values = v_val)
                                     
# Replace boolean values in specified file
file.copy(from = system.file("extdata/Falcon_D.set", package = "lazytrade"),
          to = dir, recursive = TRUE)
file_i_need <- util_find_file_with_code(files = file.path(dir, "Falcon_D.set"),
                                   code_to_find = 9142301,
                                   option_replace = TRUE,
                                   v_settings = v_par,
                                   v_values = v_val)
           

}
\author{
(C) 2024 Vladimir Zhbanko
}
