% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotExportFunctions.R
\name{embed_plot_pdf}
\alias{embed_plot_pdf}
\title{Embeds a plot into an rmarkdown pdf}
\usage{
embed_plot_pdf(plot, path, width = NULL, height = NULL)
}
\arguments{
\item{plot}{plot object created by \code{lavaanPlot}}

\item{path}{Filename to save the image}

\item{width}{width of image in pixels, NULL for default}

\item{height}{height of image, NULL for default}
}
\value{
no return value calls \code{include_graphics} to embed plot in pdf
}
\description{
Embeds a plot into an rmarkdown pdf
}
\examples{
library(lavaan)
model <- 'mpg ~ cyl + disp + hp
          qsec ~ disp + hp + wt'
fit <- sem(model, data = mtcars)
pl <- lavaanPlot(model = fit)
\dontrun{
embed_plot_pdf(pl, "plot2.pdf")
}
}
