% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_msiei.R
\name{lsm_l_msiei}
\alias{lsm_l_msiei}
\title{MSIEI (landscape level)}
\usage{
lsm_l_msiei(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Modified Simpson's evenness index (Diversity metric)
}
\details{
\deqn{MSIEi = \frac{- \ln \sum \limits_{i = 1}^{m} P_{i}^{2}} {\ln m}}
where \eqn{P_{i}} is the landscape area proportion of class i and \eqn{m} is
the number of classes.

MSIEI is a 'Diversity metric'.

Because the metric is based on distances or areas please make sure your data
is valid using \code{\link{check_landscape}}.

\subsection{Units}{None}
\subsection{Range}{0 <= MSIEI < 1}
\subsection{Behaviour}{MSIEI = 0 when only one patch is present and approaches
MSIEI = 1 as the proportional distribution of patches becomes more even}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_l_msiei(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

Simpson, E. H. 1949. Measurement of diversity. Nature 163:688

Pielou, E. C. 1975. Ecological Diversity. Wiley-Interscience, New York.
}
\seealso{
\code{\link{lsm_l_siei}}
}
