% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procrustes.R
\name{ca.procrustes}
\alias{ca.procrustes}
\title{Correspondence Analysis with Procrustes Fitting}
\usage{
ca.procrustes(obj)
}
\arguments{
\item{obj}{An incidence matrix of size n x k.}
}
\value{
A list of the following:.
\itemize{
\item \code{ref} The Procrustes-fit coordinates of the scores of the reference seriation.
\item \code{x} The Procrustes-fit coordinates of the row scores of the data.
\item \code{x.dat} A data frame containing the following information related to the fit of the row score after Procrustes fitting: \code{index}, the row name, \code{match}, the reference point nearest to the row score, and \code{dist}, the Euclidean distance between the row score and reference score point.
\item \code{y} The Procrustes-fit coordinates of the column scores of the data.
\item \code{y.dat} A data frame containing the same information as \code{x.dat}, but with respect to the column scores.
}
}
\description{
Fit scores of correspondence analysis on an incidence matrix to those produced by reference matrix which contain an ideal seriation using a Procrustes method (on the reference matrix, see \code{\link[lakhesis]{im.ref}}). Rotation is determined by minimizing Euclidean distance from each row score to the nearest reference row score. Correspondence analysis is performed using the \code{\link[ca]{ca}} package \insertCite{nenadic_correspondence_2007}{lakhesis}.
}
\examples{
data("quattrofontanili")
ca.procrustes(quattrofontanili)

}
\references{
\insertAllCited{}
}
