% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composerr.R
\name{composerr_}
\alias{composerr_}
\alias{composerr}
\alias{composerr_parent}
\title{Compose error handlers (concatenate error messages)}
\usage{
composerr_(text_1 = NULL, err_prior = NULL, text_2 = NULL,
  sep_1 = ": ", sep_2 = ": ", env_prior = parent.frame())

composerr(text_1 = NULL, err_prior = NULL, text_2 = NULL,
  sep_1 = ": ", sep_2 = ": ", env_prior = parent.frame())

composerr_parent(text_1 = NULL, err_prior = NULL, text_2 = NULL,
  sep_1 = ": ", sep_2 = ": ", env_prior = parent.frame())
}
\arguments{
\item{text_1}{A character string, which will be appended
at the beginning of the error message. The argument \code{sep_1} will be used
as text separator.}

\item{err_prior}{There are three valid types:
\itemize{
\item \code{err_prior} is omitted: A new error handling message will be returned.
\item \code{composerr_} is the calling function: \code{err_prio} must be a character
string holding the name of the error handling function
to which the message part should be appended.
\item \code{composerr} is the calling function: \code{err_prio} must be the error
handling function
to which the message part should be appended.
}}

\item{text_2}{A character string, which will be appended
at the end of the error message. The argument \code{sep_2} will be used
as text separator.}

\item{sep_1}{A character string that is used as separator for the
concatenation of \code{text_1} at the beginning of the error message.}

\item{sep_2}{A character string that is used as separator for the
concatenation of \code{text_2} at the end of the error message.}

\item{env_prior}{An environment where the error handling function given in
\code{err_prior} can be found. If no environment is given, then
the \code{err_prior} will be looked up in the current environment.
In the situation of nested scopes, you may change the lookup environment
to the parent environment in order to be able to recursively override
the name of the error handling function. In order to keep it simple,
the function \code{\link[=composerr_parent]{composerr_parent()}} can be used instead.}
}
\value{
A new error handling function that has an extended error message.
}
\description{
The functions \code{\link[=composerr]{composerr()}}, \code{\link[=composerr_]{composerr_()}} and \code{\link[=composerr_parent]{composerr_parent()}}
modify error handlers by
appending character strings to the error messages of the error handling
functions:
\itemize{
\item \code{\link[=composerr]{composerr()}} uses non-standard evaluation.
\item \code{\link[=composerr_]{composerr_()}} is the standard evaluation alternative of \code{\link[=composerr]{composerr()}}.
\item \code{\link[=composerr_parent]{composerr_parent()}} is a wrapper of \code{\link[=composerr]{composerr()}}, defining the parent
environment as the lookup environment of the \code{err_handler}.
This function looks up the prior error handling function in the parent
environment of the current environment and allows you to store
the modified error handling function under the same name as the
error handling function from the parent environment without running into
recursion issues.
This is especially useful when doing error handling
in nested environments (e.g. checking nested list objects) and you don not
want to use different names for the  error handling functions in the
nested levels.
If you don't have a nested environment situation, better use
\code{\link[=composerr]{composerr()}} or \code{\link[=composerr_]{composerr_()}}.
}
}
