% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configure_email.R
\name{configure_email}
\alias{configure_email}
\title{Configure email sending}
\usage{
configure_email(
  user = NULL,
  app.name = NULL,
  subject = NULL,
  body = NULL,
  cc = NULL,
  bcc = NULL
)
}
\arguments{
\item{user}{Character. Gmail account that will be used to send certificates.}

\item{app.name}{Name of the mail application used to send emails.
To create one, access \url{https://myaccount.google.com/apppasswords}.}

\item{subject}{Character. Subject of the email to be sent. If not specified, labeleR will use a default value.}

\item{body}{Character. Body text of the email to be sent. If not specified, labeleR will use a default value.}

\item{cc}{Character. String (or vector of strings) containing the email addresses to send the email as a copy.}

\item{bcc}{Character. String (or vector of strings) containing the email addresses to send the email as a hidden copy.}
}
\value{
A list including at least a 'user' string' and an 'app.name' string. Optionally, slots 'subject',
'body', 'cc' and 'bcc' can be edited to compile the email to send.
}
\description{
Configure the email application to automatically send certificates.
}
\examples{
\dontrun{
email.info <- configure_email(user = 'example@gmail.com')

## If you already have created an application:
email.info <- configure_email(user = 'example@gmail.com', app.name = "emailsend")

}



}
\author{
Ignacio Ramos-Gutierrez, Julia G. de Aledo, Jimena Mateo-Martín, Francisco Rodriguez-Sanchez
}
