% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kvk_API.R
\name{kvk_set_api_key}
\alias{kvk_set_api_key}
\title{Set KvK API Key for the current session}
\usage{
kvk_set_api_key(api_key)
}
\arguments{
\item{api_key}{A string containing the API key.}
}
\value{
Invisibly returns \code{TRUE} if the key was set.
}
\description{
This function sets the specified KvK API key for the \strong{current R session}
using \code{Sys.setenv()}. The key will be available until the session ends.
}
\details{
The function sets the API key using \code{Sys.setenv()}, making
it available for the current session only.

To store your API key permanently across R sessions, add the following
line to your .Renviron file:

\code{KVK_API_KEY=l7xxYourActualApiKeyHere1234567890abcdef}

You can edit your .Renviron file by running:
\code{usethis::edit_r_environ()}

After adding the key, restart R for the changes to take effect.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Set the API key for the current session
kvk_set_api_key("abcd1234")

# To store permanently, add this line to .Renviron:
# KVK_API_KEY=your_actual_api_key_here
\dontshow{\}) # examplesIf}
}
