% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{rVAR}
\alias{rVAR}
\title{Random generation from first-order vector autoregressive model}
\usage{
rVAR(n, M, Sigma, K = 1L, order = 1L, burnin = 25L)
}
\arguments{
\item{n}{sample size}

\item{M}{matrix of autoregressive coefficients}

\item{Sigma}{covariance matrix}

\item{K}{integer, degrees of freedom}

\item{order}{order of autoregressive process, only \code{1} is supported at current.}

\item{burnin}{number of iterations discarded}
}
\value{
a list of length \code{n} containing matrices of size \code{K} by \code{d}
}
\description{
Given a matrix of coefficients \code{M} and a covariance matrix \code{Sigma},
simulate \code{K} vectors from a first-order autoregressive process.
}
\examples{
M <- matrix(c(0.3, -0.3, -0.3, 0.3), nrow = 2)
Sigma <- matrix(c(1, 0.5, 0.5, 1), nrow = 2)
rVAR(n = 100, M = M, Sigma = Sigma, K = 10)
}
\keyword{internal}
