% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neiinfo.R
\name{neiinfo}
\alias{neiinfo}
\title{Compute info on `neighbor widths`}
\usage{
neiinfo(cluster, dist)
}
\arguments{
\item{cluster}{vector with assignments of data elements to clusters}

\item{dist}{distance object or matrix}
}
\value{
list with component widths. The wdiths object is a matrix
with one row per data item, wth column neighborhood holding the
sharpness value.
}
\description{
This function provides information on how well each data point
belongs to its cluster. For each query point, the function considers
n of its nearest neighbors. The neighbor widths are defined as the
fraction of those neighbors that belong to the same cluster as the
query point. These values are termed 'widths' in analogy to
silhouette widths, another measure of cluster membership.
}
\details{
The function follows a similar signature as silinfo from this package.
}
\examples{

# construct a manual clustering of the iris dataset
iris.data = iris[, 1:4]
rownames(iris.data) = paste0("iris_", seq_len(nrow(iris)))
iris.dist = dist(iris.data)
iris.clusters = setNames(as.integer(iris$Species), rownames(iris.data))

# compute neighbor-based sharpness widths
neiinfo(iris.clusters, iris.dist)

}
