% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{predict.krige}
\alias{predict.krige}
\title{Predictions by Kriging}
\usage{
\method{predict}{krige}(object, newdata, credible = FALSE, new.X, new.east, new.north, ...)
}
\arguments{
\item{object}{An \code{krige} object estimated by \code{metropolis.krige}.}

\item{newdata}{An optional data frame in which to look for variables with which 
to predict. If omitted, the fitted values are produced. Alternatively, the new 
data can be specified using \code{new.X}, \code{new.east}, and \code{new.north}.}

\item{credible}{If a credible interval on predictions is desired, a user may 
specify a proportion between 0 and 1 to indicate the interval probability. 
For example, a value of 0.9 would create a 90\% credible interval. If \code{NULL}, 
then no credible interval will be produced.}

\item{new.X}{The matrix of independent variables for observations to be predicted.}

\item{new.east}{Vector of eastings for observations to be predicted.}

\item{new.north}{Vector of northings for observations to be predicted.}

\item{\dots}{Additional arguments passed to \code{predict} methods. Not supported 
for \code{krige} objects.}
}
\value{
An object of class \code{matrix} with one prediction per row. By default 
 the matrix has one column, as only point predictions are returned. If the \code{credible} 
 option is specified, there are three columns respectively indicating a point 
 estimate (median prediction from MCMC), lower bound of the credible interval, 
 and upper bound of the credible interval.
}
\description{
This function uses the results of a model estimated by \code{metropolis.krige} 
  to make kriging-based predictions.
}
\details{
Analysts should use this function if they want to make kriged predictions 
   for observations at new locations or predict fitted values at original locations. 
   To do this, researchers first must estimate a model using the \code{metropolis.krige} 
   function.
 
 After estimating the model, a \code{krige} object can provide information from 
   the model fitted with \code{metropolis.krige}, including the original imput 
   data, coordinates, and the model results themselves. The prediction will also 
   use the same \code{powered.exp}. \code{new.data} can be specified for predicting 
   the observations at new location. Otherwise, the fitted values for the original 
   data and locations will be produced.
 
 By default, the function uses median values of parameters to make a single point 
  prediction for every kriged data point. However, if the uses specifies a probability 
  with the \code{credible} option, then the function will determine the predictions 
  for all iterations of the MCMC sample. The point estimates will then be a median 
  of these predictions, and a credible interval will be returned based on percentiles. 
  Note that estimating a credible interval is substantially more intensive computationally, 
  but has the benefit of reporting uncertainty in predictions.
}
\examples{
\dontrun{
# Summarize Data
summary(ContrivedData)

# Initial OLS model
contrived.ols<-lm(y~x.1+x.2,data=ContrivedData)
# summary(contrived.ols)

# Set seed
set.seed(1241060320)

M <- 100
#M<-10000

contrived.run <- metropolis.krige(y ~ x.1 + x.2, coords = c("s.1","s.2"), 
   data = ContrivedData, n.iter = M, range.tol = 0.05)
   
# Predict fitted values
predict(contrived.run)

# Predict new data
euler<-c(0.2,0.7)
archimedes<-c(0.3,0.1)
pythagoras<-c(0.1,0.4)
mathematicians<-rbind(euler,archimedes,pythagoras)
basel<-c(0.1,0.8)
sicily<-c(0.4,0.1)
samos<-c(0.1,0.4)
new.locations<-rbind(basel,sicily,samos)
newDf <- as.data.frame(cbind(mathematicians, new.locations))
colnames(newDf) <- c("x.1", "x.2", "s.1", "s.2")

# Make predictions from median parameter values:
(median.pred <- predict(contrived.run, newdata = newDf))

# Make predictions with 90\\% credible intervals:
(cred.pred <- predict(contrived.run, newdata = newDf, credible=0.9))
}

}
\references{
Jeff Gill. 2020. Measuring Constituency Ideology Using Bayesian Universal Kriging. 
  \emph{State Politics & Policy Quarterly}. \code{doi:10.1177/1532440020930197}
}
