% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ContrivedData}
\alias{ContrivedData}
\title{Contrived Example Data}
\format{
The \code{ContrivedData} dataset has 500 observations and 5 variables.
\describe{
  \item{\code{y}}{The outcome variable. Its true population functional form is 
    \eqn{y_s=0+1 x_{1s}+2 x_{2s}+\omega_{s}+\epsilon_{s}}. The true variance of 
    \eqn{\omega} is \eqn{\sigma^2=0.5} and of \eqn{\epsilon} is \eqn{\tau^2=0.5}. 
    The decay term that shapes spatial correlation levels is \eqn{\phi=2.5}.}
    \item{\code{x.1}}{A predictor with a standard uniform distribution.}
    \item{\code{x.2}}{A predictor with a standard normal distribution.}
    \item{\code{s.1}}{Coordinate in eastings for each observation, distributed 
      standard uniform.}
    \item{\code{s.2}}{Coordinate in northings for each observation, distributed 
      standard uniform.}
}
}
\description{
These data are a simulated point-referenced geospatial data that serve to provide 
a clean example of a kriging model. There are 500 observations with coordinates 
located on a unit square.
}
\examples{
\dontrun{
# Summarize example data
summary(ContrivedData)

# Initial OLS model
contrived.ols<-lm(y~x.1+x.2,data=ContrivedData)
# summary(contrived.ols)

# Set seed
set.seed(1241060320)

#For simple illustration, we set to few iterations.
#In this case, a 10,000-iteration run converges to the true parameters.
#If you have considerable time and hardware, delete the # on the next line.
#10,000 iterations took 39 min. with 8 GB RAM & a 1.5 GHz Quad-Core processor.
M <- 100
#M<-10000

contrived.run <- metropolis.krige(y ~ x.1 + x.2, coords = c("s.1","s.2"), 
   data = ContrivedData, n.iter = M, n.burnin=20, range.tol = 0.05)
# Alternatively, use burnin() after estimation  
#contrived.run <- burnin(contrived.run, n.burnin=20)

# Summarize the results and examine results against true coefficients	
summary(contrived.run)
(TRUTH<-c(0.5,2.5,0.5,0,1,2))
}
}
\keyword{data}
