% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_output_print.R
\name{output_print}
\alias{output_print}
\title{Output printed text with formatting}
\usage{
output_print(
  n_covariates,
  est_eff,
  beta_threshhold,
  bias = NULL,
  sustain = NULL,
  nu,
  eff_thr,
  recase,
  obs_r,
  critical_r,
  r_con,
  itcv,
  alpha,
  index,
  far_bound,
  sdx = NA,
  sdy = NA,
  R2 = NA,
  rxcv = NA,
  rycv = NA,
  rxcvGz,
  rycvGz,
  benchmark_corr_product = NA,
  itcv_ratio_to_benchmark = NA
)
}
\arguments{
\item{n_covariates}{number of covariates.}

\item{est_eff}{The estimated effect.}

\item{beta_threshhold}{The threshold value of beta, used for
statistical significance determination.}

\item{bias}{The percentage of the estimate that could be due to bias (optional).}

\item{sustain}{The percentage of the estimate necessary to sustain an inference (optional).}

\item{nu}{The hypothesized effect size used in replacement analysis.}

\item{eff_thr}{Threshold for estimated effect.}

\item{recase}{The number of cases that need to be replaced to change the inference.}

\item{obs_r}{The observed correlation coefficient in the data.}

\item{critical_r}{The critical correlation coefficient for statistical significance.}

\item{r_con}{The correlation coefficient of an omitted variable with both the outcome and the predictor.}

\item{itcv}{The impact threshold for a confounding variable.}

\item{alpha}{The level of statistical significance.}

\item{index}{A character string indicating the index for which the output is generated ('RIR' or 'IT').}

\item{far_bound}{Indicator whether the threshold is towards the other side of nu or 0, by default is zero (same side), alternative is one (the other side).}

\item{sdx}{Standard deviation of x.}

\item{sdy}{Standard deviation of y.}

\item{R2}{the unadjusted, original R2 in the observed function.}

\item{rxcv}{the correlation between x and CV.}

\item{rycv}{the correlation between y and CV.}

\item{rxcvGz}{the correlation between predictor of interest and CV necessary to nullify the inference for smallest impact, conditioning on all observed covariates.}

\item{rycvGz}{the correlation between outcome and CV necessary to nullify the inference for smallest impact, conditioning on all observed covariates.}

\item{benchmark_corr_product}{the product of the correlations of covariates Z with X and Y (Rxz * Ryz), measuring the observed association strength.}

\item{itcv_ratio_to_benchmark}{the ratio of the ITCV to the benchmark_corr_product, indicating the robustness of inference.}
}
\description{
This function outputs printed text for various indices such as RIR
(Robustness of Inference to Replacement)
and IT (Impact Threshold for a Confounding Variable) with specific formatting
 like bold, underline, and italic
using functions from the crayon package. It handles different scenarios based
 on the effect difference,
beta threshold, and other parameters, providing formatted
output for each case.
}
