% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn_forecast.R
\name{NNreg}
\alias{NNreg}
\title{Estimate a Single Point with K Nearest Neighbors Regression}
\usage{
NNreg(v, k.in2, y.in2)
}
\arguments{
\item{v}{numeric vector of similarities used to identify nearest neighbors.}

\item{k.in2}{integer value indicating the the number of nearest neighbors to be considered.}

\item{y.in2}{numeric vector of the response series to be forecast.}
}
\value{
numeric value of the mean of the \code{k.in2} nearest neighbors in \code{y.in2}.
}
\description{
Finds the index of the nearest neighbors for a single point given that point's
vector of similarities to all observations eligible to be considered as neighbors. The \code{k.in2}
neighbors are identified by their index in the similarity vector, and this index is used to
identify the neighbor points in \code{y.in2}. The function then returns the mean of the values
in \code{y.in2} identified as neighbors. It is suggested to call this function through \code{knn.forecast()}
for all points to be forecasted simultaneously.
}
\examples{
Sim.Mat <- matrix(c(1, .5, .2, .5, 1, .7, .2, .7, 1),
  nrow = 3, ncol = 3, byrow = TRUE
)
Sim.Mat.col <- Sim.Mat[-(3), 3]
y <- c(2, 1, 5)
k <- 2
NNreg(v = Sim.Mat.col, k.in2 = 2, y.in2 = y)
}
\seealso{
\code{\link[=knn.forecast]{knn.forecast()}} the recommended user facing function to perform knn
regression for forecasting with \code{NNreg()}.
}
