% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractKmers.R
\name{extractKmers}
\alias{extractKmers}
\title{Extract k-mers from a given Coordinate object and Genome objects}
\usage{
extractKmers(
  coor,
  genome,
  k,
  central.pattern = NULL,
  rm.overlap.region = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{coor}{Coordinate class object.}

\item{genome}{Genome class object.}

\item{k}{Length of k-mer.}

\item{central.pattern}{Central pattern of the k-mer, if applicable.}

\item{rm.overlap.region}{Boolean indicating if overlapping regions should be
removed. Default is TRUE.}

\item{verbose}{Boolean indicating if verbose output is enabled.}
}
\value{
A k-mer table with counts for each k-mer.
}
\description{
A k-mer table is initialized and updated in every chromosome-loop operation.
There are 3 modes of extraction. (1) When k is smaller than 9 or k is
larger than 15, the k-mer is extracted in a standard way. A k-mer table
with every possible k-mers is created and updated. (2) For k between
9 and 13, the k-mer sequence is split to half to reduce memory usage
significantly. e.g. ACGTACGTA will become ACGT ACGTA. (3) When k is
larger than 14, k-mers are extracted the same way as (1) but the k-mer
table is grown or expanded for every new k-mer found.
}
